﻿If (-NOT ([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole]::Administrator))
{
  # Relaunch as an elevated process:
  Start-Process powershell.exe "-File",('"{0}"' -f $MyInvocation.MyCommand.Path) -Verb RunAs
  exit
}

$igodrivers = Get-WindowsDriver -Online | Where-Object {$_.ProviderName -eq "intelliGo"}
$igopnpswc = Get-PnpDevice | Where-Object {$_.HardwareID -match "VEN_IGO"}
$audiosvc = Get-Service -Name Audiosrv -ErrorAction SilentlyContinue
$audioendpointbuilder = Get-Service -Name audioendpointbuilder -ErrorAction SilentlyContinue

if ($audiosvc -and $audiosvc.Status -eq "Running") {
    Stop-Service -InputObject Audiosrv -Force -ErrorAction SilentlyContinue
}

if ($audioendpointbuilder -and $audioendpointbuilder.Status -eq "Running") {
    Stop-Service -InputObject AudioEndpointBuilder -Force -ErrorAction SilentlyContinue
}

foreach ($driver in $igodrivers) {
    pnputil /delete-driver $($driver.Driver) /uninstall | out-null
    Write-Host "$($driver.OriginalFileName) is removed"
}

foreach ($swc in $igopnpswc) {
    pnputil /remove-device $($swc.DeviceID)
    Write-Host "$($swc.HardwareID) is removed"
}

$igoaudiosvc = Get-Service -Name IgoAudioService -ErrorAction SilentlyContinue
$swserver = Get-Process | Where-Object {$_.Name -match "igoswserver"}

if ($igoaudiosvc -and $igoaudiosvc.Status -eq "Running") {
    taskkill /f /im IgoAudioService_x64.exe
}

sc.exe delete "IgoAudioService" | Out-Null

if ($swserver) {
    Stop-Process $($swserver.Id) -Force
}

schtasks.exe /delete /tn "\iGoAudioTask" /f

Start-Service Audiosrv